/****************************************************************************
 **                                                                        **
 **  Various bitmap functions - Aron, 1998.                                **
 **                                                                        **
 ****************************************************************************/

#define  MAKE_RGB(R,G,B)        ((R<<16) | (G<<8) | B)

void InitTables(void);

void DrawString(char *,byte *,dword,dword,dword);

#define  STRETCH            25
#define  DIVS               800
#define  SPOKES             2048    // texturatores kikuszobolesere 256 tobbszorose kell!
void InitWormhole(void);
void DrawWormHole(byte *,byte *,byte *,dword);

void DrawZoomer(byte *,byte *,float);
void AddFrameBuffer(byte *,byte *);

void DrawMiniPicture(byte *,byte *);

void FadeFrameBuffer(byte *,byte);
void CrossFadeFrameBuffer(byte *,byte *,byte);

#define  SCALINGFACTOR      7.0
void ScaleFrameBuffer(byte *,byte *,dword);

void DrawFlyEye(byte *);

#define  IMAGES_BLURRED         4
#define  PHASES_BLURRED         8
#define  BLURBUFFER_SIZE        4*320*180
#define  SPIN_BLUR              0
#define  ZOOM_BLUR              1
void InitBlurer(byte *,dword);
void DrawBlurredImage(byte *,byte *);

void ConvertMonoFrameBuffer(byte *,byte *);

void DrawLogo(byte *destptr);

void BlinkFrameBuffer(byte *,dword);

void InitPolarizator(void);
void PolarizeBitmap(byte *,dword,dword,dword,byte *,byte,byte,byte *,byte,byte);

void BlurFrameBuffer(byte *,byte *,dword);

void RecalcTorsionTable(signed int,signed int,signed int,signed int);
void DistortBitmap(byte *,byte *);

void TwitchFrameBuffer(byte *,byte *,dword row);

void DrawBump(byte *,byte *,dword,dword);

void DrawStripes(byte *);

void DrawSquares(byte *);

void DrawInvertedStripe(byte *,dword);

void HideBorders(byte *);
